/*
 * Decompiled with CFR 0.152.
 */
package com.azuriom.azauth;

import com.azuriom.azauth.AuthResult;
import com.azuriom.azauth.exception.AuthException;
import com.azuriom.azauth.gson.ColorAdapter;
import com.azuriom.azauth.gson.InstantAdapter;
import com.azuriom.azauth.gson.UuidAdapter;
import com.azuriom.azauth.model.ErrorResponse;
import com.azuriom.azauth.model.User;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthClient {
    private static final Logger LOGGER = Logger.getLogger(AuthClient.class.getName());
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter((Type)((Object)Color.class), new ColorAdapter()).registerTypeAdapter((Type)((Object)Instant.class), new InstantAdapter()).registerTypeAdapter((Type)((Object)UUID.class), new UuidAdapter()).create();
    @NotNull
    private final String url;

    public AuthClient(@NotNull String url) {
        this.url = Objects.requireNonNull(url, "url");
        if (!url.startsWith("https://")) {
            LOGGER.warning("HTTP links are not secure, use HTTPS instead.");
        }
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @Blocking
    @NotNull
    public @NotNull AuthResult<@NotNull User> login(@NotNull String email, @NotNull String password) throws AuthException {
        return this.login(email, password, User.class);
    }

    @Blocking
    @NotNull
    public @NotNull AuthResult<@NotNull User> login(@NotNull String email, @NotNull String password, @Nullable String code2fa) throws AuthException {
        return this.login(email, password, code2fa, User.class);
    }

    @Blocking
    @NotNull
    public <T> @NotNull AuthResult<@NotNull T> login(@NotNull String email, @NotNull String password, @NotNull Class<T> responseType) throws AuthException {
        return this.login(email, password, (String)null, responseType);
    }

    @Blocking
    @NotNull
    public User login(@NotNull String email, @NotNull String password, @NotNull Supplier<String> codeSupplier) throws AuthException {
        return this.login(email, password, codeSupplier, User.class);
    }

    @Blocking
    @NotNull
    public <T> T login(@NotNull String email, @NotNull String password, @NotNull Supplier<String> codeSupplier, @NotNull Class<T> responseType) throws AuthException {
        AuthResult<T> result = this.login(email, password, responseType);
        if (result.isSuccess()) {
            return result.getSuccessResult();
        }
        if (!result.isPending() || !result.asPending().require2fa()) {
            throw new AuthException("Unknown login result: " + result);
        }
        String code = codeSupplier.get();
        if (code == null) {
            throw new AuthException("No 2FA code provided.");
        }
        result = this.login(email, password, code, responseType);
        if (!result.isSuccess()) {
            throw new AuthException("Unknown login result: " + result);
        }
        return result.getSuccessResult();
    }

    @Blocking
    @NotNull
    public <T> @NotNull AuthResult<@NotNull T> login(@NotNull String email, @NotNull String password, @Nullable String code2fa, @NotNull Class<T> responseType) throws AuthException {
        JsonObject body = new JsonObject();
        body.addProperty("email", email);
        body.addProperty("password", password);
        body.addProperty("code", code2fa);
        return this.post("authenticate", body, responseType);
    }

    @Blocking
    @NotNull
    public User verify(@NotNull String accessToken) throws AuthException {
        return this.verify(accessToken, User.class);
    }

    @Blocking
    @NotNull
    public <T> T verify(@NotNull String accessToken, @NotNull Class<T> responseType) throws AuthException {
        JsonObject body = new JsonObject();
        body.addProperty("access_token", accessToken);
        AuthResult<T> result = this.post("verify", body, responseType);
        if (!result.isSuccess()) {
            throw new AuthException("Unexpected verification result: " + result);
        }
        return result.asSuccess().getResult();
    }

    @Blocking
    public void logout(@NotNull String accessToken) throws AuthException {
        JsonObject body = new JsonObject();
        body.addProperty("access_token", accessToken);
        this.post("logout", body, null);
    }

    @Blocking
    @Contract(value="_, _, null -> null; _, _, !null -> !null")
    private <T> AuthResult<T> post(@NotNull String endPoint, @NotNull JsonObject body, @Nullable Class<T> responseType) throws AuthException {
        try {
            return this.doPost(endPoint, body, responseType);
        }
        catch (IOException e) {
            throw new AuthException(e);
        }
    }

    @Blocking
    @Contract(value="_, _, null -> null; _, _, !null -> !null")
    private <T> AuthResult<T> doPost(@NotNull String endPoint, @NotNull JsonObject body, @Nullable Class<T> responseType) throws AuthException, IOException {
        try {
            URL apiUrl = new URL(this.url + "/api/auth/" + endPoint);
            HttpURLConnection connection = (HttpURLConnection)apiUrl.openConnection();
            connection.setRequestMethod("POST");
            connection.setDoOutput(true);
            connection.addRequestProperty("User-Agent", "AzAuth authenticator v1");
            connection.addRequestProperty("Content-Type", "application/json; charset=utf-8");
            try (OutputStream out = connection.getOutputStream();){
                out.write(body.toString().getBytes(StandardCharsets.UTF_8));
            }
            int status = connection.getResponseCode();
            if (status >= 400 && status < 500) {
                return this.handleClientError(connection);
            }
            if (responseType == null) {
                return null;
            }
            return this.handleResponse(connection, responseType);
        }
        catch (IOException e) {
            throw new AuthException(e);
        }
    }

    private <T> AuthResult<T> handleResponse(HttpURLConnection connection, Class<T> type) throws AuthException, IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            T response = GSON.fromJson((Reader)reader, type);
            if (response == null) {
                throw new AuthException("Empty JSON response from API");
            }
            AuthResult.Success<T> success = new AuthResult.Success<T>(response);
            return success;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> AuthResult<T> handleClientError(HttpURLConnection connection) throws AuthException, IOException {
        int status = connection.getResponseCode();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getErrorStream()));){
            ErrorResponse response = GSON.fromJson((Reader)reader, ErrorResponse.class);
            if (!response.getStatus().equals("pending")) throw new AuthException(response.getMessage());
            if (!Objects.equals(response.getReason(), "2fa")) throw new AuthException(response.getMessage());
            AuthResult.Pending pending = new AuthResult.Pending(AuthResult.Pending.Reason.REQUIRE_2FA);
            return pending;
        }
        catch (JsonParseException e) {
            throw new AuthException("Invalid JSON response from API (http " + status + ")");
        }
    }
}

