/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.bootstrap;

import fr.theshark34.openlauncherlib.bootstrap.LaunchInfos;
import fr.theshark34.openlauncherlib.bootstrap.LauncherClasspath;
import fr.theshark34.openlauncherlib.bootstrap.LauncherInfos;
import fr.theshark34.openlauncherlib.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

public class Bootstrap {
    private LauncherClasspath launcherClasspath;
    private LauncherInfos launcherInfos;
    private LaunchInfos launchInfos;

    public Bootstrap(LauncherClasspath launcherClasspath, LauncherInfos launcherInfos) {
        this.launcherClasspath = launcherClasspath;
        this.launcherInfos = launcherInfos;
    }

    public Bootstrap(LauncherClasspath launcherClasspath, LauncherInfos launcherInfos, LaunchInfos launchInfos) {
        this.launcherClasspath = launcherClasspath;
        this.launcherInfos = launcherInfos;
        this.launchInfos = launchInfos;
    }

    public Process launch() throws IOException {
        this.printInfos();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.getJavaPath());
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            commands.addAll(Arrays.asList(this.getMacArgs()));
        }
        if (this.launchInfos != null) {
            commands.addAll(Arrays.asList(this.launchInfos.getVmArgs()));
        }
        commands.add("-cp");
        commands.add(this.constructClasspath());
        commands.add(this.launcherInfos.getMainClass());
        if (this.launchInfos != null) {
            commands.addAll(Arrays.asList(this.launchInfos.getArgs()));
        }
        String entireCommand = "";
        for (String cmd : commands) {
            entireCommand = entireCommand + cmd + "\n";
        }
        System.out.println("[OpenLauncherLib] Entire command : ");
        System.out.println(entireCommand);
        System.out.println("[OpenLauncherLib] Launching launcher");
        pb.directory(this.launcherClasspath.getLauncher().getParentFile());
        pb.command(commands);
        Process p = pb.start();
        System.out.println("[OpenLauncherLib] Successfully launched");
        File logsFile = new File(this.launcherClasspath.getLauncher().getParentFile(), "bootstraplogs.txt");
        Util.printAndWriteProcessOutput(p, logsFile);
        return p;
    }

    private void printInfos() {
        System.out.println("[OpenLauncherLib] OpenLauncherLib v2.0 Bootstrap");
        System.out.println("[OpenLauncherLib] Generating command with : ");
        System.out.println("[OpenLauncherLib]    Launcher Classpath :");
        System.out.println("[OpenLauncherLib]        Launcher     : " + this.launcherClasspath.getLauncher().getAbsolutePath());
        System.out.println("[OpenLauncherLib]        Libs Folder  : " + this.launcherClasspath.getLibsFolder().getAbsolutePath());
        System.out.println("[OpenLauncherLib]    Launcher Infos :");
        System.out.println("[OpenLauncherLib]        Server Name  : " + this.launcherInfos.getServerName());
        System.out.println("[OpenLauncherLib]        Main Class   : " + this.launcherInfos.getMainClass());
        if (this.launchInfos != null) {
            System.out.println("[OpenLauncherLib]    Launch Infos :");
            System.out.print("[OpenLauncherLib]        Arguments    : ");
            for (String arg : this.launchInfos.getArgs()) {
                System.out.print(arg);
            }
            System.out.print("\n[OpenLauncherLib]        VM Arguments : ");
            for (String arg : this.launchInfos.getVmArgs()) {
                System.out.print(arg);
            }
        }
        System.out.println("[OpenLauncherLib] Generating launch command...");
    }

    private String getJavaPath() {
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            return "\"" + System.getProperty("java.home") + "/bin/java" + "\"";
        }
        return System.getProperty("java.home") + "/bin/java";
    }

    private String[] getMacArgs() {
        String[] macArgs = new String[]{"-Xdock:name=" + this.launcherInfos.getServerName(), "-XX:+UseConcMarkSweepGC", "-XX:+CMSIncrementalMode", "-XX:-UseAdaptiveSizePolicy"};
        return macArgs;
    }

    public String constructClasspath() {
        String classpath = "";
        ArrayList<File> libs = Util.list(this.launcherClasspath.getLibsFolder());
        String separator = System.getProperty("path.separator");
        for (File lib : libs) {
            classpath = classpath + lib.getAbsolutePath() + separator;
        }
        classpath = classpath + this.launcherClasspath.getLauncher().getAbsolutePath();
        return classpath;
    }

    public LauncherClasspath getLauncherClasspath() {
        return this.launcherClasspath;
    }

    public LauncherInfos launcherInfos() {
        return this.launcherInfos;
    }

    public LaunchInfos getLaunchInfos() {
        return this.launchInfos;
    }
}

