/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.launcher;

import fr.theshark34.openlauncherlib.launcher.AuthInfos;
import fr.theshark34.openlauncherlib.launcher.GameFolder;
import fr.theshark34.openlauncherlib.launcher.GameInfos;
import fr.theshark34.openlauncherlib.launcher.GameTweak;
import fr.theshark34.openlauncherlib.util.Util;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GameLauncher {
    private GameInfos gameInfos;
    private GameFolder gameFolder;
    private AuthInfos authInfos;
    private List<String> vmArgs;

    public GameLauncher(GameInfos gameInfos, GameFolder gameFolder, AuthInfos authInfos) {
        this(gameInfos, gameFolder, authInfos, new String[0]);
    }

    public GameLauncher(GameInfos gameInfos, GameFolder gameFolder, AuthInfos authInfos, String[] vmArgs) {
        this(gameInfos, gameFolder, authInfos, Arrays.asList(vmArgs));
    }

    public GameLauncher(GameInfos gameInfos, GameFolder gameFolder, AuthInfos authInfos, List<String> vmArgs) {
        if (gameInfos == null) {
            throw new IllegalArgumentException("gameInfos == null !");
        }
        this.gameInfos = gameInfos;
        if (gameFolder == null) {
            throw new IllegalArgumentException("gameFolder == null !");
        }
        this.gameFolder = gameFolder;
        if (authInfos == null) {
            throw new IllegalArgumentException("authInfos == null !");
        }
        this.authInfos = authInfos;
        if (vmArgs == null) {
            throw new IllegalArgumentException("vmArgs == null !");
        }
        this.vmArgs = vmArgs;
    }

    public Process launch() throws IOException {
        this.printInfos();
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.getJavaPath());
        if (System.getProperty("os.name").toLowerCase().contains("mac")) {
            commands.addAll(Arrays.asList(this.getMacArgs()));
        }
        if (this.vmArgs != null) {
            commands.addAll(this.vmArgs);
        }
        commands.add("-Djava.library.path=" + new File(this.gameInfos.getGameDir(), this.gameFolder.getNativesFolder()).getAbsolutePath());
        commands.add("-cp");
        commands.add(this.constructClasspath());
        if (this.gameInfos.isTweakingEnabled()) {
            commands.add("net.minecraft.launchwrapper.Launch");
        } else {
            commands.add(this.gameInfos.getGameVersion().getGameType().getMainClass(this));
        }
        commands.addAll(this.gameInfos.getGameVersion().getGameType().getLaunchArgs(this));
        if (this.gameInfos.isTweakingEnabled()) {
            for (GameTweak tweak : this.gameInfos.getGameTweaks()) {
                commands.add("--tweakClass");
                commands.add(tweak.getTweakClass(this));
            }
        }
        String entireCommand = "";
        for (String cmd : commands) {
            entireCommand = entireCommand + cmd + "\n";
        }
        System.out.println("[OpenLauncherLib] Entire command : ");
        System.out.println(entireCommand);
        System.out.println("[OpenLauncherLib] Launching Minecraft");
        pb.directory(this.gameInfos.getGameDir());
        pb.command(commands);
        Process p = pb.start();
        System.out.println("[OpenLauncherLib] Successfully launched");
        File logsFile = new File(this.gameInfos.getGameDir(), "launcherlogs.txt");
        Util.printAndWriteProcessOutput(p, logsFile);
        return p;
    }

    private void printInfos() {
        System.out.println("[OpenLauncherLib] OpenLauncherLib v2.0 Launcher");
        System.out.println("[OpenLauncherLib] Generating command with : ");
        System.out.println("[OpenLauncherLib]    Game Infos :");
        System.out.println("[OpenLauncherLib]        Game Version   : " + this.gameInfos.getGameVersion().getName());
        System.out.println("[OpenLauncherLib]        Game Dir       : " + this.gameInfos.getGameDir().getAbsolutePath());
        System.out.println("[OpenLauncherLib]        Server Name    : " + this.gameInfos.getServerName());
        System.out.println("[OpenLauncherLib]        Game Tweaks    : " + this.gameInfos.getGameTweaks().length);
        for (GameTweak tweak : this.gameInfos.getGameTweaks()) {
            System.out.println("[OpenLauncherLib]            " + tweak.getName());
        }
        System.out.println("[OpenLauncherLib]    Game Folder :");
        System.out.println("[OpenLauncherLib]        Assets Folder  : " + this.gameFolder.getAssetsFolder());
        System.out.println("[OpenLauncherLib]        Libs Folder    : " + this.gameFolder.getLibsFolder());
        System.out.println("[OpenLauncherLib]        Natives Folder : " + this.gameFolder.getNativesFolder());
        System.out.println("[OpenLauncherLib]        Main Jar       : " + this.gameFolder.getMainJar());
        System.out.println("[OpenLauncherLib]    Auth Infos :");
        System.out.println("[OpenLauncherLib]        Username       : " + this.authInfos.getUsername());
        System.out.println("[OpenLauncherLib]        Access Token   : " + this.authInfos.getAccessToken());
        System.out.println("[OpenLauncherLib]        UUID           : " + this.authInfos.getUuid());
        System.out.println("[OpenLauncherLib] Generating launch command...");
    }

    private String getJavaPath() {
        if (System.getProperty("os.name").toLowerCase().contains("win")) {
            return "\"" + System.getProperty("java.home") + "/bin/java" + "\"";
        }
        return System.getProperty("java.home") + "/bin/java";
    }

    private String[] getMacArgs() {
        String[] macArgs = new String[]{"-Xdock:name=" + this.gameInfos.getServerName(), "-XX:+UseConcMarkSweepGC", "-XX:+CMSIncrementalMode", "-XX:-UseAdaptiveSizePolicy"};
        return macArgs;
    }

    public String constructClasspath() {
        String classpath = "";
        ArrayList<File> libs = Util.list(new File(this.gameInfos.getGameDir(), this.gameFolder.getLibsFolder()));
        String separator = System.getProperty("path.separator");
        for (File lib : libs) {
            classpath = classpath + lib.getAbsolutePath() + separator;
        }
        classpath = classpath + new File(this.gameInfos.getGameDir(), this.gameFolder.getMainJar()).getAbsolutePath();
        return classpath;
    }

    public GameFolder getGameFolder() {
        return this.gameFolder;
    }

    public GameInfos getGameInfos() {
        return this.gameInfos;
    }

    public AuthInfos getAuthInfos() {
        return this.authInfos;
    }
}

