/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.launcher;

import fr.theshark34.openlauncherlib.launcher.GameLauncher;
import java.io.File;
import java.util.ArrayList;

public abstract class GameType {
    public static final GameType V1_5_2_LOWER = new GameType(){

        @Override
        public String getName() {
            return "1.5.2 or lower";
        }

        @Override
        public String getMainClass(GameLauncher gameLauncher) {
            return "net.minecraft.launchwrapper.Launch";
        }

        @Override
        public ArrayList<String> getLaunchArgs(GameLauncher gameLauncher) {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add(gameLauncher.getAuthInfos().getUsername());
            arguments.add("token:" + gameLauncher.getAuthInfos().getAccessToken() + ":" + gameLauncher.getAuthInfos().getUuid());
            arguments.add("--gameDir");
            arguments.add(gameLauncher.getGameInfos().getGameDir().getAbsolutePath());
            arguments.add("--assetsDir");
            File assetsDir = new File(gameLauncher.getGameInfos().getGameDir(), gameLauncher.getGameFolder().getAssetsFolder());
            arguments.add(assetsDir.getAbsolutePath() + "/virtual/legacy/");
            return arguments;
        }
    };
    public static final GameType V1_7_2_LOWER = new GameType(){

        @Override
        public String getName() {
            return "1.7.2 or lower";
        }

        @Override
        public String getMainClass(GameLauncher gameLauncher) {
            return "net.minecraft.client.main.Main";
        }

        @Override
        public ArrayList<String> getLaunchArgs(GameLauncher gameLauncher) {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add("--username=" + gameLauncher.getAuthInfos().getUsername());
            arguments.add("--accessToken");
            arguments.add(gameLauncher.getAuthInfos().getAccessToken());
            arguments.add("--version");
            arguments.add(gameLauncher.getGameInfos().getGameVersion().getName());
            arguments.add("--gameDir");
            arguments.add(gameLauncher.getGameInfos().getGameDir().getAbsolutePath());
            arguments.add("--assetsDir");
            File assetsDir = new File(gameLauncher.getGameInfos().getGameDir(), gameLauncher.getGameFolder().getAssetsFolder());
            arguments.add(assetsDir.getAbsolutePath() + "/virtual/legacy/");
            arguments.add("--userProperties");
            arguments.add("{}");
            arguments.add("--uuid");
            arguments.add(gameLauncher.getAuthInfos().getUuid());
            arguments.add("--userType");
            arguments.add("legacy");
            return arguments;
        }
    };
    public static final GameType V1_7_10 = new GameType(){

        @Override
        public String getName() {
            return "1.7.10";
        }

        @Override
        public String getMainClass(GameLauncher gameLauncher) {
            return "net.minecraft.client.main.Main";
        }

        @Override
        public ArrayList<String> getLaunchArgs(GameLauncher gameLauncher) {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add("--username=" + gameLauncher.getAuthInfos().getUsername());
            arguments.add("--accessToken");
            arguments.add(gameLauncher.getAuthInfos().getAccessToken());
            arguments.add("--version");
            arguments.add(gameLauncher.getGameInfos().getGameVersion().getName());
            arguments.add("--gameDir");
            arguments.add(gameLauncher.getGameInfos().getGameDir().getAbsolutePath());
            arguments.add("--assetsDir");
            File assetsDir = new File(gameLauncher.getGameInfos().getGameDir(), gameLauncher.getGameFolder().getAssetsFolder());
            arguments.add(assetsDir.getAbsolutePath());
            arguments.add("--assetIndex");
            arguments.add(gameLauncher.getGameInfos().getGameVersion().getName());
            arguments.add("--userProperties");
            arguments.add("{}");
            arguments.add("--uuid");
            arguments.add(gameLauncher.getAuthInfos().getUuid());
            arguments.add("--userType");
            arguments.add("legacy");
            return arguments;
        }
    };
    public static final GameType V1_8_HIGHER = new GameType(){

        @Override
        public String getName() {
            return "1.8 or higher";
        }

        @Override
        public String getMainClass(GameLauncher gameLauncher) {
            return "net.minecraft.client.main.Main";
        }

        @Override
        public ArrayList<String> getLaunchArgs(GameLauncher gameLauncher) {
            ArrayList<String> arguments = new ArrayList<String>();
            arguments.add("--username=" + gameLauncher.getAuthInfos().getUsername());
            arguments.add("--accessToken");
            arguments.add(gameLauncher.getAuthInfos().getAccessToken());
            arguments.add("--version");
            arguments.add(gameLauncher.getGameInfos().getGameVersion().getName());
            arguments.add("--gameDir");
            arguments.add(gameLauncher.getGameInfos().getGameDir().getAbsolutePath());
            arguments.add("--assetsDir");
            File assetsDir = new File(gameLauncher.getGameInfos().getGameDir(), gameLauncher.getGameFolder().getAssetsFolder());
            arguments.add(assetsDir.getAbsolutePath());
            arguments.add("--assetIndex");
            arguments.add(gameLauncher.getGameInfos().getGameVersion().getName());
            arguments.add("--userProperties");
            arguments.add("{}");
            arguments.add("--uuid");
            arguments.add(gameLauncher.getAuthInfos().getUuid());
            arguments.add("--userType");
            arguments.add("legacy");
            return arguments;
        }
    };

    public abstract String getName();

    public abstract String getMainClass(GameLauncher var1);

    public abstract ArrayList<String> getLaunchArgs(GameLauncher var1);
}

