/*
 * Decompiled with CFR 0.152.
 */
package fr.theshark34.openlauncherlib.util;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.JOptionPane;

public class ErrorUtil {
    private File gameDir;

    public ErrorUtil(File gameDir) {
        this.gameDir = gameDir;
    }

    public void catchError(Exception e, String message) {
        e.printStackTrace();
        String str = "\nThe crash report is in : " + this.gameDir.getAbsolutePath() + "crash-(NOMBRE).txt";
        try {
            this.writeError(e);
        }
        catch (IOException e2) {
            e.printStackTrace();
            str = "\nAnd unable to write the crash report :( : " + e2;
        }
        JOptionPane.showMessageDialog(null, message + "\n" + e + "\n" + str, "Erreur", 0);
        System.exit(1);
    }

    private void writeError(Exception e) throws IOException {
        StackTraceElement[] stackTrace;
        File file;
        int number = 0;
        while ((file = new File(this.gameDir, "crash-" + number + ".txt")).exists()) {
            ++number;
        }
        System.out.println("[OpenLauncherLib] Writing crash report to : " + file.getAbsolutePath());
        FileWriter fw = new FileWriter(file);
        fw.write(e.toString());
        for (StackTraceElement element : stackTrace = e.getStackTrace()) {
            fw.write("\n    " + element);
        }
        fw.close();
    }
}

