/*
 * Decompiled with CFR 0.152.
 */
package net.kronos.mclib.auth.yggdrasil;

import com.google.gson.Gson;
import net.kronos.mclib.auth.yggdrasil.AuthYggdrasilException;
import net.kronos.mclib.auth.yggdrasil.model.YggdrasilAgent;
import net.kronos.mclib.auth.yggdrasil.model.YggdrasilAuthenticate;
import net.kronos.mclib.auth.yggdrasil.model.YggdrasilError;
import net.kronos.mclib.auth.yggdrasil.model.YggdrasilInvalidate;
import net.kronos.mclib.auth.yggdrasil.model.YggdrasilRefresh;
import net.kronos.mclib.auth.yggdrasil.model.YggdrasilSignout;
import net.kronos.mclib.auth.yggdrasil.model.YggdrasilValidate;
import net.kronos.mclib.auth.yggdrasil.model.response.YggdrasilAuthenticateResponse;
import net.kronos.mclib.auth.yggdrasil.model.response.YggdrasilRefreshResponse;
import net.kronos.mclib.util.HttpUtil;

public class AuthYggdrasil {
    private final String YGGDRASIL_AUTH_SERVER = "https://authserver.mojang.com/";
    private final String YGGDRASIL_AUTH_SERVER_AUTHPOINT = "authenticate";
    private final String YGGDRASIL_AUTH_SERVER_REFRESHPOINT = "refresh";
    private final String YGGDRASIL_AUTH_SERVER_VALIDATEPOINT = "validate";
    private final String YGGDRASIL_AUTH_SERVER_SIGNOUTPOINT = "signout";
    private final String YGGDRASIL_AUTH_SERVER_INVALIDATEPOINT = "invalidate";
    private boolean debug = false;

    public AuthYggdrasil(boolean debug) {
        this.debug = debug;
    }

    public YggdrasilAuthenticateResponse authenticate(YggdrasilAgent agent, String username, String password, String clientToken) throws AuthYggdrasilException {
        YggdrasilAuthenticate model = new YggdrasilAuthenticate(agent, username, password, clientToken);
        return (YggdrasilAuthenticateResponse)this.request(model, YggdrasilAuthenticateResponse.class, "authenticate");
    }

    public YggdrasilRefreshResponse refresh(String accessToken, String clientToken) throws AuthYggdrasilException {
        YggdrasilRefresh model = new YggdrasilRefresh(accessToken, clientToken);
        return (YggdrasilRefreshResponse)this.request(model, YggdrasilRefreshResponse.class, "refresh");
    }

    public void validate(String accessToken) throws AuthYggdrasilException {
        YggdrasilValidate model = new YggdrasilValidate(accessToken);
        this.request(model, "validate");
    }

    public void signout(String username, String password) throws AuthYggdrasilException {
        YggdrasilSignout model = new YggdrasilSignout(username, password);
        this.request(model, "signout");
    }

    public void invalidate(String accessToken, String clientToken) throws AuthYggdrasilException {
        YggdrasilInvalidate model = new YggdrasilInvalidate(accessToken, clientToken);
        this.request(model, "invalidate");
    }

    private void request(Object obj, String endpoint) throws AuthYggdrasilException {
        if (obj == null || endpoint == null) {
            throw new IllegalArgumentException();
        }
        this.request(obj, null, endpoint);
    }

    private Object request(Object obj, Class<?> jsonClass, String endpoint) throws AuthYggdrasilException {
        String serverReturn;
        Gson gson = new Gson();
        try {
            serverReturn = HttpUtil.performPost(this.debug, "https://authserver.mojang.com/" + endpoint, "application/json", gson.toJson(obj));
        }
        catch (Exception e) {
            YggdrasilError errorModel = gson.fromJson(e.getMessage(), YggdrasilError.class);
            if (errorModel == null) {
                errorModel = new YggdrasilError();
                errorModel.setErrorMessage(e.getMessage());
            }
            throw new AuthYggdrasilException(errorModel);
        }
        if (jsonClass != null) {
            return gson.fromJson(serverReturn, jsonClass);
        }
        return null;
    }
}

