/*
 * Decompiled with CFR 0.152.
 */
package net.kronos.mclib.util;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import javax.net.ssl.HttpsURLConnection;
import net.kronos.mclib.auth.yggdrasil.model.YggdrasilError;
import net.kronos.mclib.util.LogUtil;

public class HttpUtil {
    public static String encodeUrl(String text, String enc) {
        try {
            return URLEncoder.encode(text, enc);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String concatenatePars(String[][] pars) {
        String finalPars = "";
        int i = 0;
        while (i <= pars.length) {
            finalPars = String.valueOf(finalPars) + (i == 0 ? "?" : "&") + pars[0][i] + "=" + pars[1][i];
            ++i;
        }
        return finalPars;
    }

    public static String performGet(boolean debug, String stringUrl, String pars) {
        if (debug) {
            LogUtil.print(LogUtil.Level.normal, "Performing get on \"" + stringUrl + "\" with data " + pars);
        }
        InputStream is = null;
        try {
            URL url = new URL(String.valueOf(stringUrl) + pars);
            is = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String response = br.readLine();
            if (debug) {
                LogUtil.print(LogUtil.Level.normal, "Get response: " + response);
            }
            String string = response;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "";
    }

    public static String performPost(boolean debug, String stringUrl, String contentType, String postData) throws Exception {
        YggdrasilError errorModel;
        if (debug) {
            LogUtil.print(LogUtil.Level.normal, "Performing post on \"" + stringUrl + "\" with data " + postData);
        }
        BufferedReader rd = null;
        HttpURLConnection connection = null;
        String response = null;
        try {
            byte[] byteData = postData.getBytes();
            URL url = new URL(stringUrl);
            connection = (HttpsURLConnection)url.openConnection();
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", contentType);
            connection.setRequestProperty("Content-Length", Integer.toString(byteData.length));
            connection.setRequestProperty("Content-Language", "en-US");
            connection.setUseCaches(false);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            DataOutputStream wr = new DataOutputStream(connection.getOutputStream());
            wr.write(byteData);
            wr.flush();
            wr.close();
            InputStream is = null;
            if (connection.getResponseCode() != 200) {
                is = connection.getErrorStream();
                if (is == null) {
                    return null;
                }
                rd = new BufferedReader(new InputStreamReader(is));
                response = rd.readLine();
                if (debug) {
                    LogUtil.print(LogUtil.Level.normal, "Post response: " + response);
                }
                throw new Exception(response);
            }
            is = connection.getInputStream();
            rd = new BufferedReader(new InputStreamReader(is));
            response = rd.readLine();
            if (debug) {
                LogUtil.print(LogUtil.Level.normal, "Post response: " + response);
            }
            String string = response;
            return string;
        }
        catch (UnknownHostException e) {
            errorModel = new YggdrasilError();
            errorModel.setError("UnknownHostException");
            errorModel.setErrorMessage("\"" + stringUrl + "\" is unreachable.");
            errorModel.setCause("");
            throw new Exception(new Gson().toJson(errorModel));
        }
        catch (IOException e) {
            errorModel = new YggdrasilError();
            errorModel.setError("mclauncher-library has encountered an error.");
            errorModel.setErrorMessage(e.toString());
            errorModel.setCause("");
            throw new Exception(new Gson().toJson(errorModel));
        }
        finally {
            try {
                if (rd != null) {
                    rd.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

