/*
 * Decompiled with CFR 0.152.
 */
package net.tryvania.launcher;

import fr.theshark34.openlauncherlib.bootstrap.Bootstrap;
import fr.theshark34.openlauncherlib.bootstrap.LauncherClasspath;
import fr.theshark34.openlauncherlib.bootstrap.LauncherInfos;
import fr.theshark34.openlauncherlib.util.GameDir;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import net.tryvania.launcher.elements.CustomBackground;
import net.tryvania.launcher.elements.CustomBar;
import net.tryvania.launcher.elements.CustomButton;
import net.tryvania.launcher.elements.UpdaterThread;

public class LauncherBootstrap
extends JFrame
implements MouseListener {
    private static LauncherBootstrap instance;
    private final LauncherInfos SC_B_INFOS = new LauncherInfos("tryvania", "fr.thisismac.core.Start");
    private final File CS_DIR = GameDir.createGameDir("tryvania");
    private final LauncherClasspath SC_B_CP = new LauncherClasspath(new File(this.CS_DIR, "launcher.jar"), new File(this.CS_DIR, "libs"));
    Font font = new Font("Arial", 0, 14);
    CustomButton quit = new CustomButton(295, 7, "/close.png", "/close_hover.png");
    CustomButton reduce = new CustomButton(255, 7, "/reduce.png", "/reduce_hover.png");
    CustomBar bar = new CustomBar(17, 412, "/progress_full.png");
    private Point initialClick;
    boolean debug;

    public static LauncherBootstrap get() {
        return instance;
    }

    public LauncherBootstrap(boolean debug) {
        instance = this;
        this.debug = debug;
        this.setSize(338, 504);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(3);
        this.setResizable(false);
        this.setLayout(null);
        this.setUndecorated(true);
        this.setFocusTraversalKeysEnabled(false);
        this.setFocusable(true);
        try {
            this.setIconImage(ImageIO.read(LauncherBootstrap.class.getResource("/favicon.png")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                LauncherBootstrap.this.initialClick = e.getPoint();
                LauncherBootstrap.this.getComponentAt(LauncherBootstrap.this.initialClick);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int thisX = LauncherBootstrap.this.getLocation().x;
                int thisY = LauncherBootstrap.this.getLocation().y;
                int xMoved = thisX + e.getX() - (thisX + ((LauncherBootstrap)LauncherBootstrap.this).initialClick.x);
                int yMoved = thisY + e.getY() - (thisY + ((LauncherBootstrap)LauncherBootstrap.this).initialClick.y);
                int X = thisX + xMoved;
                int Y = thisY + yMoved;
                LauncherBootstrap.this.setLocation(X, Y);
            }
        });
        this.quit.setOpaque(false);
        this.reduce.setOpaque(false);
        this.reduce.addMouseListener(this);
        this.quit.addMouseListener(this);
        this.bar.setOpaque(false);
        this.bar.setFont(this.font);
        CustomBackground bg = new CustomBackground();
        bg.setBounds(0, 0, 338, 504);
        this.add(this.quit);
        this.add(this.reduce);
        this.add(this.bar);
        this.add(bg);
        this.setVisible(true);
        this.doUpdate();
    }

    public void doUpdate() {
        new UpdaterThread().start();
    }

    public void launchLauncher() throws IOException {
        Bootstrap bootstrap = new Bootstrap(this.SC_B_CP, this.SC_B_INFOS);
        try {
            Process p = bootstrap.launch();
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setVisible(false);
    }

    public CustomBar getBar() {
        return this.bar;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.quit) {
            System.exit(0);
        } else if (e.getSource() == this.reduce) {
            this.setState(1);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }
}

