/*
 * Decompiled with CFR 0.152.
 */
package net.tryvania.launcher.elements;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JProgressBar;

public class CustomBar
extends JProgressBar {
    private Image image;
    private int x;
    private int y;
    boolean download;
    String displayMessage;
    int maximumSize;
    public int currentSize;
    int fileLeft;

    public CustomBar(int x, int y, String texturePath) {
        try {
            this.image = ImageIO.read(CustomBar.class.getResource(texturePath));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        BufferedImage tmp = (BufferedImage)this.image;
        this.setBounds(x, y, tmp.getWidth(), tmp.getHeight());
        this.setBorder(null);
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.white);
        int percent = this.maximumSize > 0 ? (int)((float)this.currentSize / (float)this.maximumSize * 100.0f) : 0;
        g.drawImage(this.image, this.x, this.y, (int)((double)this.getWidth() * ((double)percent / 100.0)), this.getHeight(), this);
        FontMetrics fm = g.getFontMetrics();
        if (fm == null) {
            return;
        }
        if (this.download) {
            String str = String.valueOf(percent) + " % / " + this.fileLeft + " fichiers restants";
            g.drawString(str, this.x + this.getWidth() / 2 - fm.stringWidth(str) / 2, this.y + this.getHeight() / 2 + 3);
        } else if (this.displayMessage != null && this.displayMessage.length() > 0) {
            g.drawString(this.displayMessage, this.x + this.getWidth() / 2 - fm.stringWidth(this.displayMessage) / 2, this.y + this.getHeight() / 2 + 3);
        }
    }

    public void addToCurrentSize(int i) {
        this.currentSize += i;
    }

    public void decrementeFileLeft() {
        --this.fileLeft;
    }

    public void setDisplayMessage(String message) {
        this.displayMessage = message;
    }

    public void setFileleft(int filesize) {
        this.fileLeft = filesize;
    }

    public int getFileLeft() {
        return this.fileLeft;
    }

    public boolean isDownload() {
        return this.download;
    }

    public void setMaximumSize(int maximumSize) {
        this.maximumSize = maximumSize;
    }

    public void setDownload(boolean download) {
        this.download = download;
    }
}

