/*
 * Decompiled with CFR 0.152.
 */
package net.tryvania.launcher.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class HashUtils {
    public static String getMD5(File file) throws NoSuchAlgorithmException, IOException {
        int numBytes;
        MessageDigest md = MessageDigest.getInstance("MD5");
        FileInputStream stream = new FileInputStream(file);
        md.reset();
        byte[] bytes = new byte[65536];
        while ((numBytes = stream.read(bytes)) != -1) {
            md.update(bytes, 0, numBytes);
        }
        byte[] digest = md.digest();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < digest.length) {
            sb.append(Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1));
            ++i;
        }
        return sb.toString();
    }

    public static String getSHA(String passwd) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA1");
        byte[] hash = md.digest(passwd.getBytes("UTF-8"));
        StringBuilder sb = new StringBuilder(2 * hash.length);
        byte[] byArray = hash;
        int n = hash.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            sb.append(String.format("%02x", b & 0xFF));
            ++n2;
        }
        return sb.toString();
    }

    public static String getSHA1(File file) throws NoSuchAlgorithmException, IOException {
        int bytesRead;
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        FileInputStream fis = new FileInputStream(file);
        byte[] dataBytes = new byte[1024];
        while ((bytesRead = fis.read(dataBytes)) != -1) {
            md.update(dataBytes, 0, bytesRead);
        }
        byte[] mdBytes = md.digest();
        StringBuilder sb = new StringBuilder();
        byte[] byArray = mdBytes;
        int n = mdBytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte mdByte = byArray[n2];
            sb.append(Integer.toString((mdByte & 0xFF) + 256, 16).substring(1));
            ++n2;
        }
        return sb.toString();
    }
}

