/*
 * Decompiled with CFR 0.152.
 */
package net.tryvania.launcher.utils;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import net.tryvania.launcher.elements.CustomFile;
import net.tryvania.launcher.utils.DirUtils;
import net.tryvania.launcher.utils.HashUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLUtils {
    public static void prepareLauncher(List<CustomFile> toDownload) {
        try {
            InputStream xml = new URL("https://launcher.tryvania.net/launcher/launcher.xml").openStream();
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xml);
            Node node = doc.getFirstChild();
            int i = 0;
            while (i < node.getChildNodes().getLength()) {
                Node parse = node.getChildNodes().item(i);
                if (parse.getNodeName().equals("Contents")) {
                    File local;
                    String key = parse.getChildNodes().item(1).getTextContent().replace("\\", "/");
                    String md5 = parse.getChildNodes().item(3).getTextContent().replace("\"", "");
                    int size = Integer.parseInt(parse.getChildNodes().item(5).getTextContent());
                    if (size > 0) {
                        local = new File(DirUtils.getWorkingDirectory(), key);
                        if (!local.exists() || !HashUtils.getMD5(local).equals(md5)) {
                            File parentDir = local.getParentFile();
                            if (!parentDir.exists()) {
                                parentDir.mkdirs();
                            }
                            System.out.println(String.valueOf(local.getAbsolutePath()) + " will be downloaded");
                            toDownload.add(new CustomFile(size, "https://launcher.tryvania.net/launcher/" + key, local.getAbsolutePath()));
                        }
                    } else {
                        local = new File(DirUtils.getWorkingDirectory(), key);
                        if (!local.exists()) {
                            local.mkdirs();
                        }
                    }
                }
                ++i;
            }
            xml.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void prepareLibs(List<CustomFile> toDownload) {
        try {
            InputStream xml = new URL("https://launcher.tryvania.net/launcher/libs.xml").openStream();
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(xml);
            Node node = doc.getFirstChild();
            int i = 0;
            while (i < node.getChildNodes().getLength()) {
                Node parse = node.getChildNodes().item(i);
                if (parse.getNodeName().equals("Contents")) {
                    File local;
                    String key = parse.getChildNodes().item(1).getTextContent().replace("\\", "/");
                    String md5 = parse.getChildNodes().item(3).getTextContent().replace("\"", "");
                    int size = Integer.parseInt(parse.getChildNodes().item(5).getTextContent());
                    if (size > 0) {
                        local = new File(DirUtils.getWorkingDirectory(), key);
                        if (!local.exists() || !HashUtils.getMD5(local).equals(md5)) {
                            File parentDir = local.getParentFile();
                            if (!parentDir.exists()) {
                                parentDir.mkdirs();
                            }
                            System.out.println(String.valueOf(local.getAbsolutePath()) + " will be downloaded");
                            toDownload.add(new CustomFile(size, "https://launcher.tryvania.net/launcher/" + key, local.getAbsolutePath()));
                        }
                    } else {
                        local = new File(DirUtils.getWorkingDirectory(), key);
                        if (!local.exists()) {
                            local.mkdirs();
                        }
                    }
                }
                ++i;
            }
            xml.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

